<?php
    require __DIR__ . '/vendor/autoload.php';
    use Google\Spreadsheet\DefaultServiceRequest;
    use Google\Spreadsheet\ServiceRequestFactory;

    putenv('GOOGLE_APPLICATION_CREDENTIALS=' . __DIR__ . '/credentials.json');

    $client = new Google_Client;
    $client->useApplicationDefaultCredentials();
    $client->setApplicationName("My App");
    $client->setScopes(['https://www.googleapis.com/auth/drive','https://spreadsheets.google.com/feeds']);
    if ($client->isAccessTokenExpired()) {
        $client->refreshTokenWithAssertion();
    }
    $accessToken = $client->fetchAccessTokenWithAssertion()["access_token"];
    ServiceRequestFactory::setInstance(
        new DefaultServiceRequest($accessToken)
    );
    $service = new Google_Service_Sheets($client);
    $sheet_id = "1ImlNLaRpJjD4mm52ixIuR6yFl5v_QBA1wpKRgrmGOq8";
	
	$range = "A1:N5000";//"A6:C6";
	
	$name   = $_POST['country'];
	$phone  = $_POST['number'];
	$page_url = $_POST['page_url'];
	
	$value = array(
		array("$name","$phone")
	);		 
	$body = new Google_Service_Sheets_ValueRange([
        'values' => $value
    ]);
	$params = [
		'valueInputOption' => "RAW"
	];
	$insert = ['valueDataOption' => "INSERT_ROWS"];
	if(!empty($phone)){
		$results1 = $service->spreadsheets_values->append(
			$sheet_id,
			$range,
			$body,
			$params,
			$insert
		);
		/* printf("Form Submited successfully.", $results1->getUpdates()->getUpdatedCells()); */
		header('Location: '.$page_url);
	} else {
		echo "Please fill the form data";
	}
?>